#include <cvirte.h>		
#include <userint.h>
#include "PolledAO.h"
#include <windows.h>
#include <ansi_c.h>
#include "drvlinx.h"
#include "dlcodes.h"


static int panelHandle;
// declare some variables for DriverLINX to use
HWND window;
HINSTANCE driverInstance;
DL_SERVICEREQUEST *pSR; 
// declare a variable for the requested voltage
double volts;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "PolledAO.uir", PANEL)) < 0)
		return -1;

	// **********************************************************************
	// Open Driver and Initialize hardware 
	window=FindWindow(NULL,"Single Value AO with DriverLINX");		//Get the Window handle from the CVI panel
	driverInstance=OpenDriverLINX(window,"kdda816");  //Pass the window handle to open the driver
	/*
	  in above line, replace the "kdda816" with name of your driver in order to
	  avoid the OpenDriverLINX dialog box.  For example, kpci3130 for the KPCI-3130 Series of boards
	
	*/
	pSR=(DL_SERVICEREQUEST*)malloc(sizeof(DL_SERVICEREQUEST));  //Allocate space for the Service Request
	memset(pSR,0,sizeof(DL_SERVICEREQUEST));   //Initialize the Service Request
	DL_SetServiceRequestSize(*pSR);    	//Setup the Service Request for usage
	pSR->hWnd=window;                	//Set the Widows handle property
	pSR->device=0; 						//Set the device property, in this case it is device 0	
	pSR->subsystem=DEVICE;				//We are commnicating with the DEVICE, not AI, AO, etc..																		
	pSR->mode=OTHER;					//The mode is OTHER, not DMA or INTerrupt
	pSR->operation=INITIALIZE;			//The operation is to INITIALIZE the driver													 
	DriverLINX(pSR);					//Execute the Service Request
			
	if(pSR->result!=NoErr)				//Check for errors
		{
			pSR->operation=MESSAGEBOX;
			DriverLINX(pSR);
		}
	// setup a polled mode AO task
	
			pSR->mode=POLLED;			//The mode is POLLED I/O
			pSR->subsystem=AO;			// use AO subsystem of the board
			pSR->operation = START;
			pSR->channels.nChannels=1;	//The total number of channels is 1
			pSR->channels.chanGain[0].channel=0;//this single channel will be channel 0
			// line below can select different ranges of the board's AO subsystem
			// in cases where the hardware provides software selection of ranges
			//pSR->channels.chanGain[0].gainOrRange = Gain2Code(0,AO,-1); // bipolar gain of 1 requested
			//***************************************************************************
			pSR->status.typeStatus=IOVALUE;		//We are sending an I/O value
			
// see call back for the KNOB to see what happens next			
// ***************************************************************************

	// resume with the CVI generated code
	DisplayPanel (panelHandle); 
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		// clean up allocated variables of DriverLINX
			free(pSR);
			pSR = NULL;
			CloseDriverLINX(driverInstance);
			QuitUserInterface (0);
			break;
		}
	return 0;
}

int CVICALLBACK KNOBCALLBACK (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		// using the CVI examples on events, many many events fire for the object
		// on the panel.  However, COMMIT seems to be the last one always once
		// mouse activity with the object stops.  Use this event to update the value
		// of voltage on the DAC
		case EVENT_COMMIT:
			GetCtrlVal (panel, PANEL_NUMERICKNOB, &volts);   // read in the Knob's value
			pSR->status.u.ioValue=Volts2Code(0,AO,volts);   // convert it to counts and give it to 
			                                                // the ioValue member
			DriverLINX(pSR);					//Execute the Service Request
    		if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			break;
		}
	return 0;
}
